#ifndef LLF_RSA_HASH_DES_H
#define LLF_RSA_HASH_DES_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "tomcrypt.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object name     :  LLF_RSA_HashDesc.h
*  State           :  %state%
*  Creation date   :  6.08.2007
*  Last modified   :  %modify_time%
*/
/** @file
* \brief contains definitions of the hash structures for RSA only
*	The difference with TomCrypt definition is in DER identifier
*
*  \version LLF_RSA_HashDesc.h#1:cinc:1
* \author 
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd. All rights reserved.
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/

const struct ltc_hash_descriptor sha1_descDx =
{
  "sha1Dx",
  2,
  20,
  64,

  /* DER identifier */
  { 0x30, 0x21, 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 
  0x03, 0x02, 0x1A, 0x05, 0x00, 0x04, 0x14 },
  15,

  &sha1_init,
  &sha1_process,
  &sha1_done,
  &sha1_test,
  NULL
};


const struct ltc_hash_descriptor md5_descDx =
{
  "md5Dx",
  3,
  16,
  64,

  /* DER identifier */
  { 0x30, 0x20, 0x30, 0x0C, 0x06, 0x08, 0x2A, 0x86, 
  0x48, 0x86, 0xF7, 0x0D, 0x02, 0x05, 0x05, 0x00, 
  0x04, 0x10 },
  18,

  &md5_init,
  &md5_process,
  &md5_done,
  &md5_test,
  NULL
};

const struct ltc_hash_descriptor sha512_descDx =
{
  "sha512Dx",
  5,
  64,
  128,

  // DER identifier 
  { 0x30, 0x51, 0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 
  0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x03, 0x05, 
  0x00, 0x04, 0x40 },
  19,

  &sha512_init,
  &sha512_process,
  &sha512_done,
  &sha512_test,
  NULL
};

const struct ltc_hash_descriptor sha384_descDx =
{
  "sha384Dx",
  4,
  48,
  128,

  // DER identifier 
  { 0x30, 0x41, 0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 
  0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x02, 0x05, 
  0x00, 0x04, 0x30 },
  19,

  &sha384_init,
  &sha512_process,
  &sha384_done,
  &sha384_test,
  NULL
};

const struct ltc_hash_descriptor sha256_descDx =
{
  "sha256Dx",
  0,
  32,
  64,

  // DER identifier 
  { 0x30, 0x31, 0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 
  0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01, 0x05, 
  0x00, 0x04, 0x20 },
  19,

  &sha256_init,
  &sha256_process,
  &sha256_done,
  &sha256_test,
  NULL
};

const struct ltc_hash_descriptor sha224_descDx =
{
  "sha224Dx",
  10,
  28,
  64,

  // DER identifier 
  { 0x30, 0x2D, 0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 
  0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x04, 0x05, 
  0x00, 0x04, 0x1C },
  19,

  &sha224_init,
  &sha256_process,
  &sha224_done,
  &sha224_test,
  NULL
};

/************************ Public Functions ********************/

#ifdef __cplusplus
}
#endif

#endif // LLF_RSA_HASH_DES_H
